import { createTheme, lighten } from '@mui/material/styles';

// Your primary colors
const primaryMain = '#093083';
const primaryLight = lighten(primaryMain, 0.15); // Lightened version for background

const theme = createTheme({
  palette: {
    primary: {
      main: primaryMain, // your main primary color (dark blue)
      light: primaryLight, // a lighter blue variant
      dark: '#333', // a darker shade for hover/focus
      contrastText: '#fff', // text color on primary backgrounds
    },
    action: {
      hover: primaryLight + ' !important', // light gray on hover
    },
  },
  typography: {
    fontFamily: `var(--font-1), 'Helvetica', 'Arial', sans-serif`,
    body1: {
      fontSize: '1rem', // Sets the font size of the body text (default)
    },
    body2: {
      fontSize: '1rem', // You can adjust body2 if needed
    },
    h1: {
      fontSize: '2rem', // Example: Adjusting the size for headings
    },
    h2: {
      fontSize: '1.75rem',
    },
    h3: {
      fontSize: '1.5rem',
    },
    h4: {
      fontSize: '1.25rem',
    },
    h5: {
      fontSize: '1rem', // Heading 5
    },
    h6: {
      fontSize: '0.875rem', // Heading 6
    },
  },
});

export default theme;
