import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { NavLink } from 'react-router-dom';
const PropertyCard = ({ property }) => {
    const scrollToTop = () => {
        window.scrollTo({
            top: 0,
            behavior: 'smooth', // Smooth scroll to top
        });
    };
    const { ProfileImage, TotalImage, v_link, SaveFave, DetailUrl, BedroomsTitle, BathroomsTitle, parking, LocationTitleOffering, AdTitle, priceWithCurrncy, agent_phone, agent_email, Whatsaplink, } = property;
    const baseUrl = window.location.origin;
    return (_jsx("div", { className: "col col-sm-6 col-md-3 plr-3 p-card", "data-add": AdTitle, children: _jsxs("div", { className: "card card-property card-link taphover", children: [_jsxs("div", { className: "card-image", children: [_jsx("div", { className: "full-block card-image-inner transition", style: { backgroundImage: `url(${ProfileImage})` } }), _jsx("div", { className: "full-block overlay transition" }), _jsx("div", { className: "property-media", children: _jsxs("span", { children: [_jsx("i", { className: "fa fa-camera" }), " ", TotalImage] }) }), v_link && (_jsxs("div", { className: "3d-tour-icon", children: [_jsx("svg", { viewBox: "0 0 15 15", width: "25", height: "25", className: "button_icon-style3", children: _jsx("use", { xlinkHref: "#viewd-3d" }) }), _jsx("span", { className: "tour-label", children: "3D Tour" })] })), _jsxs("div", { className: "card-hover transition", children: [_jsx("span", { className: "icon-click" }), _jsxs("span", { className: "click-text", children: [_jsx("span", { className: "gold", children: "Click" }), " to explore"] }), _jsx("span", { className: "arrow transition" })] }), _jsx("div", { dangerouslySetInnerHTML: { __html: SaveFave } }), _jsx(NavLink, { to: `${baseUrl}${DetailUrl}`, onClick: scrollToTop, className: "full-block", "aria-label": "View Property Details" })] }), _jsxs("div", { className: "property-icons", children: [BedroomsTitle && (_jsx("div", { className: "property-icon", children: _jsxs("div", { className: "d-align-center", children: [_jsx("span", { className: "shado  ", children: _jsx("img", { src: "/img/icon-bedroom.svg", alt: "Bedrooms" }) }), _jsxs("span", { className: "b-value-parent", children: [" ", _jsx("span", { className: "b-value", children: BedroomsTitle !== 'Studio' ? BedroomsTitle : '' }), "  ", _jsx("span", { children: BedroomsTitle !== 'Studio' ? 'Bedrooms' : 'Studio' })] })] }) })), BathroomsTitle && (_jsx("div", { className: "property-icon", children: _jsxs("div", { className: "d-align-center property-icon-flex", children: [_jsx("span", { className: "shado", children: _jsx("img", { src: "/img/icon-bathroom.svg", alt: "Bathrooms" }) }), _jsxs("span", { className: "b-value-parent", children: [" ", _jsx("span", { className: "b-value", children: BathroomsTitle }), "  ", _jsx("span", { children: "Bathrooms" })] })] }) })), parking && (_jsx("div", { className: "property-icon", children: _jsxs("div", { className: "d-align-center", children: [_jsx("span", { className: "shado", children: _jsx("img", { src: "/img/icon-reception.svg", alt: "Parking" }) }), _jsxs("span", { className: "b-value-parent", children: [" ", _jsx("span", { className: "b-value", children: parking }), "  ", _jsx("span", { children: "Parking" })] })] }) }))] }), _jsxs("div", { className: "card-content card-contentts pb-0", children: [_jsx("h3", { children: _jsx(NavLink, { to: `${baseUrl}${DetailUrl}`, onClick: scrollToTop }) }), LocationTitleOffering && (_jsx("p", { dangerouslySetInnerHTML: { __html: LocationTitleOffering } })), _jsx("p", { className: "price", children: priceWithCurrncy })] }), _jsxs("div", { className: "actions mt-0", children: [_jsxs("a", { className: "btn btn-outline-secondary", href: `tel:${agent_phone}`, target: "_blank", rel: "noopener noreferrer", "aria-label": `Call ${agent_phone}`, children: [_jsx("img", { alt: "Call", src: "/img/telephone.png" }), _jsx("span", { children: "Call" })] }), _jsxs("a", { className: "btn btn-outline-secondary", href: `mailto:${agent_email}`, target: "_blank", rel: "noopener noreferrer", "aria-label": `Email ${agent_email}`, children: [_jsx("img", { alt: "Email", src: "/img/email.png" }), _jsx("span", { children: "Email" })] }), _jsxs("a", { href: Whatsaplink, target: "_blank", className: "btn btn-outline-secondary whatsapp-color", rel: "noopener noreferrer", "aria-label": "WhatsApp", children: [_jsx("img", { alt: "WhatsApp", src: "/img/whatsapp.png" }), _jsx("span", { children: "WhatsApp" })] })] })] }) }));
};
export default PropertyCard;
